/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.model;

import com.badlogic.gdx.graphics.Color;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.assets.model.OverlapType;
import technology.rocketjump.undermount.mapping.tile.floor.FloorOverlap;
import technology.rocketjump.undermount.rendering.HexColors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FloorType {
    private final String floorTypeName;
    private long floorTypeId;
    private final GameMaterialType materialType;
    private final int layer;
    private final int numSprites;
    private OverlapType overlapType;
    private final boolean useMaterialColor;
    private String lowColorCode;
    @JsonIgnore
    private Color lowColor;
    private String highColorCode;
    @JsonIgnore
    private Color highColor;

    @JsonCreator
    public FloorType(@JsonProperty(value="floorTypeName") String floorTypeName, @JsonProperty(value="floorTypeId") long floorTypeId, @JsonProperty(value="materialType") GameMaterialType materialType, @JsonProperty(value="layer") int layer, @JsonProperty(value="numSprites") int numSprites, @JsonProperty(value="overlapType") OverlapType overlapType, @JsonProperty(value="useMaterialColor") boolean useMaterialColor, @JsonProperty(value="lowColorCode") String lowColorCode, @JsonProperty(value="highColorCode") String highColorCode) {
        this.floorTypeName = floorTypeName;
        this.floorTypeId = floorTypeId;
        this.materialType = materialType;
        this.layer = layer;
        this.numSprites = numSprites;
        this.overlapType = overlapType;
        this.useMaterialColor = useMaterialColor;
        this.lowColorCode = lowColorCode;
        if (lowColorCode != null) {
            this.lowColor = HexColors.get(lowColorCode);
        }
        this.highColorCode = highColorCode;
        if (highColorCode != null) {
            this.highColor = HexColors.get(highColorCode);
        }
    }

    public String getFloorTypeName() {
        return this.floorTypeName;
    }

    public GameMaterialType getMaterialType() {
        return this.materialType;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getNumSprites() {
        return this.numSprites;
    }

    public OverlapType getOverlapType() {
        return this.overlapType;
    }

    public boolean isUseMaterialColor() {
        return this.useMaterialColor;
    }

    public void setOverlapType(OverlapType overlapType) {
        this.overlapType = overlapType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloorType that = (FloorType)o;
        return new EqualsBuilder().append(this.layer, that.layer).append((Object)this.materialType, (Object)that.materialType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.materialType).append(this.layer).toHashCode();
    }

    public long getFloorTypeId() {
        return this.floorTypeId;
    }

    public void setFloorTypeId(long floorTypeId) {
        this.floorTypeId = floorTypeId;
    }

    public String getLowColorCode() {
        return this.lowColorCode;
    }

    public void setLowColorCode(String lowColorCode) {
        this.lowColorCode = lowColorCode;
    }

    public Color getLowColor() {
        return this.lowColor;
    }

    public void setLowColor(Color lowColor) {
        this.lowColor = lowColor;
    }

    public String getHighColorCode() {
        return this.highColorCode;
    }

    public void setHighColorCode(String highColorCode) {
        this.highColorCode = highColorCode;
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public void setHighColor(Color highColor) {
        this.highColor = highColor;
    }

    public Color getColorForHeightValue(float heightmapValue) {
        if (this.lowColor == null || this.highColor == null) {
            return Color.TEAL;
        }
        float cursor = (double)heightmapValue < 0.5 ? 1.0f - heightmapValue * 2.0f : (heightmapValue - 0.5f) * 2.0f;
        return this.lowColor.cpy().lerp(this.highColor, cursor);
    }

    public static class FloorDefinitionComparator
    implements Comparator<FloorOverlap> {
        @Override
        public int compare(FloorOverlap o1, FloorOverlap o2) {
            return o1.getFloorType().getLayer() - o2.getFloorType().getLayer();
        }
    }
}

